<?php

class EWRporta_Model_Promotes extends XenForo_Model
{
	public function getPromoteByThreadId($threadId)
	{
		if (!$promote = $this->_getDb()->fetchRow("
			SELECT *
				FROM EWRporta_promotes
			WHERE thread_id = ?
		", $threadId))
		{
			return false;
		}

		return $promote;
	}

	public function getPromoteForums()
	{
		if (!$forums = $this->_getDb()->fetchRow("
			SELECT *
				FROM EWRporta_settings
			WHERE setting_name = ?
		", 'recentnews_forum'))
		{
			return false;
		}

		$forums = explode(',', $forums['setting_value']);

		return $forums;
	}

	public function updatePromotion($input)
	{
		$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Promotes');

		if ($promote = $this->getPromoteByThreadId($input['thread_id']))
		{
			$dw->setExistingData($promote);
		}

		if ($input['delete'])
		{
			$dw->delete();
		}
		else
		{
			if ($input['ampm'] == 'pm')
			{
				$input['hour'] = $input['hour']+12;
			}

			$dw->bulkSet(array(
				'thread_id' => $input['thread_id'],
				'promote_date' => mktime(
					$input['hour'],
					$input['minute'],
					0,
					$input['month'],
					$input['day'],
					$input['year']
				),
			));
			$dw->save();
		}

		return true;
	}
}